#include "apputils.h"

using namespace uos_ai;

QMap<QString, QString> AppUtils::kApp2IconMap = {
    {"dde-file-manager", "dde-file-manager.svg"},
    {"uos-ai-assistant", "UosAiAssistantLogo.svg"},
    {"deepin-mail", "deepin-mail.svg"},
    {"dde-calendar", "dde-calendar.svg"},
    {"org.deepin.browser", "org.deepin.browser.svg"},
    {"deepin-editor", "deepin-editor.svg"},
    {"deepin-screen-recorder", "deepin-screen-recorder.svg"},
    {"deepin-voice-note", "deepin-voice-note.svg"},
    {"deepin-reader", "deepin-reader.svg"},
    {"deepin-home-appstore-client", "deepin-app-store.svg"},
    {"dman", "deepin-manual.svg"},
    {"wps", "/opt/apps/cn.wps.wps-office-pro/entries/icons/hicolor/256x256/mimetypes/wps-office2023-wpsmain.png"},
    {"et", "/opt/apps/cn.wps.wps-office-pro/entries/icons/hicolor/256x256/mimetypes/wps-office2023-etmain.png"},
    {"wpp", "/opt/apps/cn.wps.wps-office-pro/entries/icons/hicolor/256x256/mimetypes/wps-office2023-wppmain.png"},
    {"qq", "linux.qq.com.png||/opt/apps/linux.qq.com/entries/icons/hicolor/512x512/apps/qq.png"},
    {"SuwellReader", "/opt/apps/cn.suwell.reader/entries/icons/hicolor/256x256/mimetypes/cn.suwell.reader.app-x-suwellreader.png"},
    {"com.alibabainc.dingtalk", "/opt/apps/com.alibabainc.dingtalk/files/logo.ico"},
    {"FoxitOfficeSuite", "cn.foxitjj.foxitofficesuite.svg||/opt/apps/cn.foxitjj.foxitofficesuite/entries/icons/hicolor/256x256/apps/cn.foxitjj.foxitofficesuite.png"},
    {"Foxit PDF Editor", "/opt/apps/com.foxit.foxitpdfeditor/files/resource/icons/scalable/apps/phantom.svg"},
    {"yozo-writer", "yozoicon-writer.svg"},
    {"yozo", "yozoicon.svg"},
    {"yozo-impress", "yozoicon-impress.svg"},
    {"yozo-calc", "yozoicon-calc.svg"},
    {"xReader", "com-yozosoft-xreader.svg"},
    {"wpspdf", "/opt/apps/cn.wps.wps-office-pro/entries/icons/hicolor/256x256/mimetypes/wps-office2023-pdfmain.png"},
    {"doubao", "com.doubao.uos.png"},
    {"foxmail.exe", "com.foxmail.deepin.svg"},
    {"com.zjd.gov", "/opt/apps/com.zjd.gov/files/logo.svg"},
    {"wechat", "com.tencent.wechat.png"},
    {"wxwork.exe", "com.qq.weixin.work.deepin.svg"},
    {"com.bytedance.feishu", "com.bytedance.feishu.svg"},
    {"google-chrome", "google-chrome.svg"},
};

AppUtils::AppUtils() : QObject()
{
    m_app2NameMap = {
        {"dde-file-manager", tr("File Manager")},
        {"uos-ai-assistant", tr("UOS AI")},
        {"deepin-mail", tr("Mail")},
        {"dde-calendar", tr("Calendar")},
        {"org.deepin.browser", tr("Web Browser")},
        {"deepin-editor", tr("Text Editor")},
        {"deepin-screen-recorder", tr("Screenshot")},
        {"deepin-voice-note", tr("Voice Notes")},
        {"deepin-reader", tr("Document Viewer")},
        {"deepin-home-appstore-client", tr("App Store")},
        {"dman", tr("Manual")},
        {"wps", tr("WPS Writer")},
        {"et", tr("WPS Spreadsheets")},
        {"wpp", tr("WPS Presentation")},
        {"qq", tr("QQ")},
        {"SuwellReader", tr("SuwellReader")},
        {"com.alibabainc.dingtalk", tr("DingTalk")},
        {"FoxitOfficeSuite", tr("FoxitOfficeSuite")},
        {"Foxit PDF Editor", tr("Foxit PDF Editor")},
        {"yozo-writer", tr("Yozo Document 2024")},
        {"yozo", tr("Yozo Office 2024")},
        {"yozo-impress", tr("Yozo Presentation 2024")},
        {"yozo-calc", tr("Yozo Sheet 2024")},
        {"xReader", tr("Yozo-xReader")},
        {"wpspdf", tr("wpspdf")},
        {"doubao", tr("doubao")},
        {"foxmail.exe", tr("Foxmail")},
        {"com.zjd.gov", tr("zjd")},
        {"wechat", tr("Wechat")},
        {"wxwork.exe", tr("WXWork")},
        {"com.bytedance.feishu", tr("Feishu")},
        {"google-chrome", tr("Chrome")},
    };
}
