/**
 * Deepin官网
 * deepin的官方网站后台接口
 *
 * The version of the OpenAPI document: 1.0
 * Contact: wurongjie@deepin.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#ifndef DH_DHUserApi_H
#define DH_DHUserApi_H

#include "DHHelpers.h"
#include "DHHttpRequest.h"
#include "DHServerConfiguration.h"
#include "DHOauth.h"

#include "DHFeedback_CreateFeedbackRequest.h"
#include "DHFeedback_CreateFeedbackResponse.h"
#include "DHFeedback_UserListResponse.h"
#include "DHFeedback_UserRelationListResponse.h"
#include "DHFeedback_UserRelationResposne.h"
#include "DHHandlers_ClientLoginRequest.h"
#include "DHHandlers_ClientLoginResponse.h"
#include "DHHandlers_ClientUserInfoResponse.h"
#include "DHHandlers_PreUploadRequest.h"
#include "DHHandlers_PreUploadResponse.h"
#include <QString>

#include <QObject>
#include <QByteArray>
#include <QStringList>
#include <QList>
#include <QNetworkAccessManager>

namespace DeepinHomeAPI {

class DHUserApi : public QObject {
    Q_OBJECT

public:
    DHUserApi(const int timeOut = 0);
    ~DHUserApi();

    void initializeServerConfigs();
    int setDefaultServerValue(int serverIndex,const QString &operation, const QString &variable,const QString &val);
    void setServerIndex(const QString &operation, int serverIndex);
    void setApiKey(const QString &apiKeyName, const QString &apiKey);
    void setBearerToken(const QString &token);
    void setUsername(const QString &username);
    void setPassword(const QString &password);
    void setTimeOut(const int timeOut);
    void setWorkingDirectory(const QString &path);
    void setNetworkAccessManager(QNetworkAccessManager* manager);
    int addServerConfiguration(const QString &operation, const QUrl &url, const QString &description = "", const QMap<QString, DHServerVariable> &variables = QMap<QString, DHServerVariable>());
    void setNewServerForAllOperations(const QUrl &url, const QString &description = "", const QMap<QString, DHServerVariable> &variables =  QMap<QString, DHServerVariable>());
    void setNewServer(const QString &operation, const QUrl &url, const QString &description = "", const QMap<QString, DHServerVariable> &variables =  QMap<QString, DHServerVariable>());
    void addHeaders(const QString &key, const QString &value);
    void enableRequestCompression();
    void enableResponseCompression();
    void abortRequests();
    QString getParamStylePrefix(const QString &style);
    QString getParamStyleSuffix(const QString &style);
    QString getParamStyleDelimiter(const QString &style, const QString &name, bool isExplode);

    /**
    * @param[in]  data DHHandlers_ClientLoginRequest [required]
    */
    void clientLogin(const DHHandlers_ClientLoginRequest &data);

    /**
    * @param[in]  data DHFeedback_CreateFeedbackRequest [required]
    */
    void createFeedback(const DHFeedback_CreateFeedbackRequest &data);

    /**
    * @param[in]  id QString [required]
    * @param[in]  relation QString [required]
    */
    void createFeedbackRelation(const QString &id, const QString &relation);

    /**
    * @param[in]  offset double [required]
    * @param[in]  limit double [required]
    * @param[in]  id QList<QString> [optional]
    * @param[in]  relation QList<QString> [optional]
    */
    void getFeedbackRelation(const double &offset, const double &limit, const ::DeepinHomeAPI::OptionalParam<QList<QString>> &id = ::DeepinHomeAPI::OptionalParam<QList<QString>>(), const ::DeepinHomeAPI::OptionalParam<QList<QString>> &relation = ::DeepinHomeAPI::OptionalParam<QList<QString>>());


    void getLoginInfo();

    /**
    * @param[in]  offset double [required]
    * @param[in]  limit double [required]
    * @param[in]  type QString [optional]
    * @param[in]  status QString [optional]
    */
    void getUserFeedback(const double &offset, const double &limit, const ::DeepinHomeAPI::OptionalParam<QString> &type = ::DeepinHomeAPI::OptionalParam<QString>(), const ::DeepinHomeAPI::OptionalParam<QString> &status = ::DeepinHomeAPI::OptionalParam<QString>());

    /**
    * @param[in]  data DHHandlers_PreUploadRequest [required]
    */
    void preUpload(const DHHandlers_PreUploadRequest &data);

    /**
    * @param[in]  id QString [required]
    * @param[in]  relation QString [required]
    */
    void removeFeedbackRelation(const QString &id, const QString &relation);


private:
    QMap<QString,int> _serverIndices;
    QMap<QString,QList<DHServerConfiguration>> _serverConfigs;
    QMap<QString, QString> _apiKeys;
    QString _bearerToken;
    QString _username;
    QString _password;
    int _timeOut;
    QString _workingDirectory;
    QNetworkAccessManager* _manager;
    QMap<QString, QString> _defaultHeaders;
    bool _isResponseCompressionEnabled;
    bool _isRequestCompressionEnabled;
    DHHttpRequestInput _latestInput;
    DHHttpRequestWorker *_latestWorker;
    QStringList _latestScope;
    OauthCode _authFlow;
    OauthImplicit _implicitFlow;
    OauthCredentials _credentialFlow;
    OauthPassword _passwordFlow;
    int _OauthMethod = 0;

    void clientLoginCallback(DHHttpRequestWorker *worker);
    void createFeedbackCallback(DHHttpRequestWorker *worker);
    void createFeedbackRelationCallback(DHHttpRequestWorker *worker);
    void getFeedbackRelationCallback(DHHttpRequestWorker *worker);
    void getLoginInfoCallback(DHHttpRequestWorker *worker);
    void getUserFeedbackCallback(DHHttpRequestWorker *worker);
    void preUploadCallback(DHHttpRequestWorker *worker);
    void removeFeedbackRelationCallback(DHHttpRequestWorker *worker);

signals:

    void clientLoginSignal(DHHandlers_ClientLoginResponse summary);
    void createFeedbackSignal(DHFeedback_CreateFeedbackResponse summary);
    void createFeedbackRelationSignal(DHFeedback_UserRelationResposne summary);
    void getFeedbackRelationSignal(QList<DHFeedback_UserRelationListResponse> summary);
    void getLoginInfoSignal(DHHandlers_ClientUserInfoResponse summary);
    void getUserFeedbackSignal(QList<DHFeedback_UserListResponse> summary);
    void preUploadSignal(DHHandlers_PreUploadResponse summary);
    void removeFeedbackRelationSignal(DHFeedback_UserRelationResposne summary);

    void clientLoginSignalFull(DHHttpRequestWorker *worker, DHHandlers_ClientLoginResponse summary);
    void createFeedbackSignalFull(DHHttpRequestWorker *worker, DHFeedback_CreateFeedbackResponse summary);
    void createFeedbackRelationSignalFull(DHHttpRequestWorker *worker, DHFeedback_UserRelationResposne summary);
    void getFeedbackRelationSignalFull(DHHttpRequestWorker *worker, QList<DHFeedback_UserRelationListResponse> summary);
    void getLoginInfoSignalFull(DHHttpRequestWorker *worker, DHHandlers_ClientUserInfoResponse summary);
    void getUserFeedbackSignalFull(DHHttpRequestWorker *worker, QList<DHFeedback_UserListResponse> summary);
    void preUploadSignalFull(DHHttpRequestWorker *worker, DHHandlers_PreUploadResponse summary);
    void removeFeedbackRelationSignalFull(DHHttpRequestWorker *worker, DHFeedback_UserRelationResposne summary);

    void clientLoginSignalE(DHHandlers_ClientLoginResponse summary, QNetworkReply::NetworkError error_type, QString error_str);
    void createFeedbackSignalE(DHFeedback_CreateFeedbackResponse summary, QNetworkReply::NetworkError error_type, QString error_str);
    void createFeedbackRelationSignalE(DHFeedback_UserRelationResposne summary, QNetworkReply::NetworkError error_type, QString error_str);
    void getFeedbackRelationSignalE(QList<DHFeedback_UserRelationListResponse> summary, QNetworkReply::NetworkError error_type, QString error_str);
    void getLoginInfoSignalE(DHHandlers_ClientUserInfoResponse summary, QNetworkReply::NetworkError error_type, QString error_str);
    void getUserFeedbackSignalE(QList<DHFeedback_UserListResponse> summary, QNetworkReply::NetworkError error_type, QString error_str);
    void preUploadSignalE(DHHandlers_PreUploadResponse summary, QNetworkReply::NetworkError error_type, QString error_str);
    void removeFeedbackRelationSignalE(DHFeedback_UserRelationResposne summary, QNetworkReply::NetworkError error_type, QString error_str);

    void clientLoginSignalEFull(DHHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void createFeedbackSignalEFull(DHHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void createFeedbackRelationSignalEFull(DHHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void getFeedbackRelationSignalEFull(DHHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void getLoginInfoSignalEFull(DHHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void getUserFeedbackSignalEFull(DHHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void preUploadSignalEFull(DHHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void removeFeedbackRelationSignalEFull(DHHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);

    void abortRequestsSignal();
    void allPendingRequestsCompleted();

public slots:
    void tokenAvailable();
    
};

} // namespace DeepinHomeAPI
#endif
